<!doctype html>
<html class="no-js" lang="en">
    <?php
    $settings = \App\Models\GeneralSetting::find(1);
    ?>
<head>
    <meta charset="utf-8">
    <meta http-equiv="x-ua-compatible" content="ie=edge">
     <title><?php if($settings): ?><?php echo e($settings->site_title); ?><?php endif; ?></title>
     <meta name="description" content="<?php if($settings): ?><?php echo e($settings->meta_description); ?><?php endif; ?>">
    <meta name="title" content="<?php if($settings): ?><?php echo e($settings->meta_title); ?><?php endif; ?>">
    <meta name="viewport" content="width=device-width, initial-scale=1">

     <link rel="shortcut icon" type="image/x-admin-icon" href="<?php if($settings): ?><?php echo e(asset('admin-assets/images/logos')); ?>/<?php echo e($settings->favicon); ?><?php endif; ?>">
    <!-- Place favicon.ico in the root directory -->

    <!-- CSS here -->
    <?php echo $__env->make('user.includes.styles', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
    <?php echo $__env->yieldContent('custom-styles'); ?>
</head>

<body>

    <!-- Dark/Light-toggle -->
    <div class="darkmode-trigger">
        <label class="modeSwitch">
            <input type="checkbox">
            <span class="icon"></span>
        </label>
    </div>
    <!-- Dark/Light-toggle-end -->

    <!-- Scroll-top -->
    <button class="scroll-top scroll-to-target" data-target="html">
        <i class="fas fa-angle-up"></i>
    </button>
    <!-- Scroll-top-end-->

    <!-- header-area -->
    <header>
        <div id="header-fixed-height"></div>
        <div class="header-top-wrap">
            <div class="container-fluid p-0">
                <div class="row align-items-center">
                    <div class="col-md-6">
                        <div class="header-top-menu">
                            <ul class="list-wrap">
                                <li><a href="<?php echo e(route('gold.rates')); ?>">Gold</a></li>
                                <li><a href="<?php echo e(route('forex.crypto')); ?>">Forex/Crypto</a></li>
                                <li><a href="<?php echo e(route('prayer.times')); ?>">Prayer Timings</a></li>
                                <li><a href="<?php echo e(route('frontend-stores')); ?>">Brands</a></li>
                            </ul>
                        </div>
                    </div>
                    <div class="col-md-6">
                        <div class="header-top-social d-none d-md-flex">
                            <h5 class="title">Follow Us:</h5>
                            <ul class="list-wrap">
                                <?php
                                $socials = \App\Models\SocialMedia::all();
                            ?>
                            <?php if($socials): ?>

                                <?php $__currentLoopData = $socials; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $row): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <li> <a href="<?php echo e($row->url); ?>" target="_blank">
                                            <i class="<?php echo e($row->icon); ?> me-2"></i></a></li>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            <?php endif; ?>
                            </ul>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        
    </header>

    <!-- header-area-end -->


    <!-- main-area -->
    <main class="fix">

        <?php echo $__env->yieldContent('content'); ?>

    </main>
    <!-- main-area-end -->

    <!-- footer-area -->


    <!-- footer-area-end -->
    

    <!-- JS here -->
    <?php echo $__env->make('user.includes.scripts', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
    <?php echo $__env->yieldContent('custom-scripts'); ?>
    <script>
     $(document).on('keyup', '.search-input', function () {
    var keyword = $('.search-input').val();
    console.log(keyword);
    $.ajax({
        type: 'GET',
        url: "<?php echo e(route('get-blogs')); ?>",
        data: {
            key: keyword
        },
        success: function (resp) {
            console.log(resp);
            $('.autocomplete').css('display', 'block');
            $('.autocomplete').html(resp);
        },
        error: function (resp) {
            console.log(resp);
        }
    });
});
    </script>
</body>

</html>
<?php /**PATH /home/coupuzzt/realtimebrief.com/resources/views/user/layouts/auth.blade.php ENDPATH**/ ?>