<!doctype html>
<html class="no-js" lang="en">
    <?php
    $settings = \App\Models\GeneralSetting::find(1);
    ?>
<head>
    <meta charset="utf-8">
    <meta http-equiv="x-ua-compatible" content="ie=edge">
    <?php echo $__env->yieldContent('meta-content'); ?>
    <meta name="viewport" content="width=device-width, initial-scale=1">

     <link rel="shortcut icon" type="image/x-admin-icon" href="<?php if($settings): ?><?php echo e(asset('admin-assets/images/logos')); ?>/<?php echo e($settings->favicon); ?><?php endif; ?>">
    <!-- Place favicon.ico in the root directory -->
   
    <!-- CSS here -->
    <?php echo $__env->make('user.includes.styles', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
    <?php echo $__env->yieldContent('custom-styles'); ?>
    
   
</head>

<body class="uni-body panel bg-white text-gray-900 dark:bg-black dark:text-white text-opacity-50 overflow-x-hidden">

    <!--  Search modal -->
    <div id="uc-search-modal" class="uc-modal-full uc-modal" data-uc-modal="overlay: true">
        <div class="uc-modal-dialog d-flex justify-center bg-white text-dark dark:bg-gray-900 dark:text-white"
            data-uc-height-viewport="">
            <button
                class="uc-modal-close-default p-0 icon-3 btn border-0 dark:text-white dark:text-opacity-50 hover:text-primary hover:rotate-90 duration-150 transition-all"
                type="button">
                <i class="unicon-close"></i>
            </button>
            <div class="panel w-100 sm:w-500px px-2 py-10">
                <h3 class="h1 text-center">Search</h3>
                <form class="hstack gap-1 mt-4 border-bottom p-narrow dark:border-gray-700" action="?">
                    <span
                        class="d-inline-flex justify-center items-center w-24px sm:w-40 h-24px sm:h-40px opacity-50"><i
                            class="unicon-search icon-3"></i></span>
                    <input type="search" name="q"
                        class="form-control-plaintext ms-1 fs-6 sm:fs-5 w-full dark:text-white search-input"
                        placeholder="Type your keyword.." aria-label="Search" autofocus>
                </form>
                <div class="autocomplete" style="display:none"></div>
            </div>
        </div>
    </div>

    <!--  Menu panel -->
    <div id="uc-menu-panel" data-uc-offcanvas="overlay: true;">
        <div class="uc-offcanvas-bar bg-white text-dark dark:bg-gray-900 dark:text-white">
            <header class="uc-offcanvas-header hstack justify-between items-center pb-4 bg-white dark:bg-gray-900">
                <div class="uc-logo">
                    <a href="index.html" class="h5 text-none text-gray-900 dark:text-white">
                        <img class="" src="<?php echo e(asset('user-assets/images/logo-light.svg')); ?>" alt="News5">
                    </a>
                </div>
                <button
                    class="uc-offcanvas-close p-0 icon-3 btn border-0 dark:text-white dark:text-opacity-50 hover:text-primary hover:rotate-90 duration-150 transition-all"
                    type="button">
                    <i class="unicon-close"></i>
                </button>
            </header>

            <div class="panel">
                <form id="search-panel" class="form-icon-group vstack gap-1 mb-3" data-uc-sticky="">
                    <input type="email" class="form-control form-control-md fs-6" placeholder="Search..">
                    <span class="form-icon text-gray">
                        <i class="unicon-search icon-1"></i>
                    </span>
                </form>
                <ul class="nav-y gap-narrow fw-bold fs-5" data-uc-nav>
                    <li><a href="<?php echo e(route('index')); ?>">Home</a></li>
                    <?php
                                $categories = \App\Models\Category::select('id', 'slug', 'name')
                                    ->limit(6)
                                    ->get();
                            ?>
                            <?php $__currentLoopData = $categories; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $row): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <li class="uc-parent">
                        <a href="<?php echo e(route('blogs.category', $row->slug)); ?>"><?php echo e($row->name); ?> </a>
                        <ul class="uc-nav-sub" data-uc-nav="">
                            <?php
                            $subcategories = \App\Models\SubCategory::select(
                                'id',
                                'name',
                                'slug',
                            )
                                ->where('category_id', $row->id)
                                ->get();
                        ?>
                            <?php $__currentLoopData = $subcategories; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $subcategory): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <li><a href="<?php echo e(route('blogs.subcategory', ['categoryslug' => $row->slug, 'subcategoryslug' => $subcategory->slug])); ?>"><?php echo e($subcategory->name); ?></a></li>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </ul>
                    </li>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    
                    <li>
                        <a href="<?php echo e(route('forex.crypto')); ?>">Forex/ Crypto</a>
                    </li>
                    <li>
                        <a href="<?php echo e(route('gold.rates')); ?>">Gold</a>
                    </li>
                    <li>
                        <a href="<?php echo e(route('prayer.times')); ?>">Prayers Timings</a>
                    </li>
                    <li>
                        <a href="<?php echo e(route('frontend-stores')); ?>">Brands</a>
                    </li>
                    
                    <li class="hr opacity-10 my-1"></li>
                    <li><a href="sign-in.html">Sign in</a></li>
                    <li><a href="sign-up.html">Create an account</a></li>
                </ul>
                <ul class="social-icons nav-x mt-4">
                    <li>
                        <?php
                        $social_links = \App\Models\SocialMedia::get();
                    ?>
                    <?php $__currentLoopData = $social_links; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $link): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <a href="<?php echo e($link->url); ?>"><i class="unicon-logo-<?php echo e($link->title); ?> icon-2"></i></a>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </li>
                </ul>
                <div class="py-2 hstack gap-2 mt-4 bg-white dark:bg-gray-900" data-uc-sticky="position: bottom">
                    <div class="vstack gap-1">
                        <span class="fs-7 opacity-60">Select theme:</span>
                        <div class="darkmode-trigger" data-darkmode-switch="">
                            <label class="switch">
                                <input type="checkbox">
                                <span class="slider fs-5"></span>
                            </label>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <!-- header-area -->
    <?php echo $__env->make('user.includes.header', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>


    <!-- header-area-end -->


    <!-- main-area -->
    <div id="wrapper" class="wrap overflow-hidden-x">
        <?php echo $__env->yieldContent('content'); ?>

    </div>
    <!-- main-area-end -->

    <!-- footer-area -->
    <?php echo $__env->make('user.includes.footer', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>


    <!-- footer-area-end -->


    <!-- JS here -->

    <?php echo $__env->make('user.includes.scripts', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
    
    <?php echo $__env->yieldContent('custom-scripts'); ?>
    <script>
         $(document).on('keyup', '.search-input', function() {
            var keyword = $('.search-input').val();
            console.log(keyword);
            $.ajax({
                type: 'GET',
                url: "<?php echo e(route('get-blogs')); ?>",
                data: {
                    key: keyword
                },
                success: function(resp) {
                    console.log(resp);
                    $('.autocomplete').css('display', 'block');
                    $('.autocomplete').html(resp);
                },
                error: function(resp) {
                    console.log(resp);
                }
            });
        });
    </script>
   

</body>

</html>
<?php /**PATH F:\Laravel\realtimebrief\resources\views/user/layouts/app.blade.php ENDPATH**/ ?>