
<?php $__env->startSection('custom-styles'); ?>
    <style>
        .table thead th:first-child {
            background: #0179c8 !important;
            color: white
        }

        .table thead th {
            background: #fff !important;
            color: black
        }

        .table thead th {
            border-right: solid 1px #cccccc;
        }

        .table tbody tr:nth-child(even) {
            background: #d4edfe;
        }

        .table tbody tr:nth-child(odd) {
            background: #FFF;
        }
    </style>
<?php $__env->stopSection(); ?>
<?php $__env->startSection('meta-content'); ?>
 <?php
    $settings = \App\Models\GeneralSetting::find(1);
    ?>
<title><?php if($settings): ?><?php echo e($settings->site_title); ?><?php endif; ?></title>
<meta name="description" content="<?php if($settings): ?><?php echo e($settings->meta_description); ?><?php endif; ?>">
<meta name="title" content="<?php if($settings): ?><?php echo e($settings->meta_title); ?><?php endif; ?>">
<?php $__env->stopSection(); ?>
<?php $__env->startSection('content'); ?>
    <!-- breadcrumb-area -->
    <div class="breadcrumb-area">
        <div class="container">
            <div class="row">
                <div class="col-lg-12">
                    <div class="breadcrumb-content">
                        <nav aria-label="breadcrumb">
                            <ol class="breadcrumb">
                                <li class="breadcrumb-item"><a href="<?php echo e(route('index')); ?>">Home</a></li>
                                <li class="breadcrumb-item" aria-current="page"><a href="javascript:;">Gold Rates</a></li>
                            </ol>
                        </nav>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <!-- breadcrumb-area-end -->
    <section class="blog-details-area pt-60 pb-60">
        <div class="container">
            <div class="author-inner-wrap">
                <div class="row justify-content-center">
                    <div class="col-70">
                        <div class="section-title-wrap mb-30">
                            <div class="section-title">
                                <h2 class="title">Gold Rate Per Gram (USD, AED, PKR, INR)</h2>
                            </div>
                            <div class="section-title-line"></div>
                        </div>
                        <div class="table-responsive">
                            <table class="table table-hover table-responsive">
                                <thead>
                                    <tr>
                                        <th scope="col">Currency</th>
                                        <th scope="col">TYPE</th>
                                        <th scope="col">24K</th>
                                        <th scope="col">22K</th>
                                        <th scope="col">21K</th>
                                        <th scope="col">18K</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    <?php $__currentLoopData = $goldrates; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $rate): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <tr>
                                            <th scope="row"><?php echo e(\Str::upper($rate->currency_code)); ?></th>
                                            <th><?php echo e($rate->unit_type); ?></th>
                                            <td><?php echo e(number_format($rate->ounce_gold_rate * $rate->karat24_rate, 2, '. ', ',')); ?>

                                            </td>
                                            <td><?php echo e(number_format($rate->ounce_gold_rate * $rate->karat22_rate, 2, '. ', ',')); ?>

                                            </td>
                                            <td><?php echo e(number_format($rate->ounce_gold_rate * $rate->karat21_rate, 2, '. ', ',')); ?>

                                            </td>
                                            <td><?php echo e(number_format($rate->ounce_gold_rate * $rate->karat18_rate, 2, '. ', ',')); ?>

                                            </td>
                                        </tr>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </tbody>
                            </table>
                        </div>
                        <div class="section-title-wrap mt-30 mb-30">
                            <div class="section-title">
                                <h2 class="title">Gold Rate Per 1Tola (USD, AED, PKR, INR)</h2>
                            </div>
                            <div class="section-title-line"></div>
                        </div>
                        <div class="table-responsive">
                            <table class="table table-hover table-responsive">
                                <thead>
                                    <tr>
                                        <th scope="col">Currency</th>
                                        <th scope="col">TYPE</th>
                                        <th scope="col">24K</th>
                                        <th scope="col">22K</th>
                                        <th scope="col">21K</th>
                                        <th scope="col">18K</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    <?php $__currentLoopData = $goldrates; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $rate): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <tr>
                                            <th scope="row"><?php echo e(\Str::upper($rate->currency_code)); ?></th>
                                            <th>1 Tola</th>
                                            <td><?php echo e(number_format($rate->ounce_gold_rate * $rate->karat24_rate * 11.7, 2, '. ', ',')); ?>

                                            </td>
                                            <td><?php echo e(number_format($rate->ounce_gold_rate * $rate->karat22_rate * 11.7, 2, '. ', ',')); ?>

                                            </td>
                                            <td><?php echo e(number_format($rate->ounce_gold_rate * $rate->karat21_rate * 11.7, 2, '. ', ',')); ?>

                                            </td>
                                            <td><?php echo e(number_format($rate->ounce_gold_rate * $rate->karat18_rate * 11.7, 2, '. ', ',')); ?>

                                            </td>
                                        </tr>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </tbody>
                            </table>
                        </div>
                        


                        <div id='2572dba0-aff5-45e6-a242-01a24b36cbfa' data-symbols="" style='width:100%;height:100%;'>
                        </div>
                    </div>
                    <div class="col-30">
                        <div class="sidebar-wrap">
                            <div class="sidebar-widget">
                                <div class="sidebar-search">
                                    <form action="#">
                                        <input type="text" placeholder="Search . . .">
                                        <button type="submit"><i class="flaticon-search"></i></button>
                                    </form>
                                </div>
                            </div>
                            <div class="sidebar-widget sidebar-widget-two">
                                <div class="widget-title mb-30">
                                    <h6 class="title">Hot Categories</h6>
                                    <div class="section-title-line"></div>
                                </div>
                                <div class="sidebar-categories">
                                    <ul class="list-wrap">
                                        <?php $__currentLoopData = $categories; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $row): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                            <li>
                                                <a href="<?php echo e(route('blogs.category',$row->slug)); ?>"
                                                    data-background="<?php echo e(asset('admin-assets/images/categories')); ?>/<?php echo e($row->feature_image); ?>">
                                                    <span class="post-tag post-tag-three"><?php echo e($row->name); ?></span>
                                                    <span class="right-arrow">
                                                        <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 16 16"
                                                            fill="none">
                                                            <path
                                                                d="M1.72308 16L0 14.2769L11.8154 2.46154H1.23077V0H16V14.7692H13.5385V4.18462L1.72308 16Z"
                                                                fill="currentcolor"></path>
                                                            <path
                                                                d="M1.72308 16L0 14.2769L11.8154 2.46154H1.23077V0H16V14.7692H13.5385V4.18462L1.72308 16Z"
                                                                fill="currentcolor"></path>
                                                        </svg>
                                                    </span>
                                                </a>
                                            </li>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                    </ul>
                                </div>
                            </div>

                            <div class="sidebar-widget sidebar-widget-two">
                                <div class="widget-title mb-30">
                                    <h6 class="title">Recent News</h6>
                                    <div class="section-title-line"></div>
                                </div>
                                <div class="hot-post-wrap">
                                    <?php
                                        $blog = $blogs->shift();
                                    ?>
                                    <div class="hot-post-item">
                                        <div class="hot-post-thumb">
                                            <a href="<?php echo e(route('blog.details', $blog->slug)); ?>"><img
                                                    src="<?php echo e(asset('admin-assets/images/blogs')); ?>/<?php echo e($blog->feature_image); ?>"
                                                    alt=""></a>
                                        </div>
                                        <div class="hot-post-content">
                                            <a href="javascript:;" class="post-tag"><?php echo e($blog->category->name); ?></a>
                                            <h4 class="post-title"><a
                                                    href="<?php echo e(route('blog.details', $blog->slug)); ?>"><?php echo e($blog->title); ?></a>
                                            </h4>
                                            <div class="blog-post-meta">
                                                <ul class="list-wrap">
                                                    <li><i
                                                            class="flaticon-calendar"></i><?php echo e($blog->updated_at->toFormattedDateString()); ?>

                                                    </li>
                                                    <li><i
                                                            class="flaticon-history"></i><?php echo e($blog->updated_at->diffForHumans()); ?>

                                                    </li>
                                                </ul>
                                            </div>
                                        </div>
                                    </div>
                                    <?php $__currentLoopData = $blogs; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $row): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <div class="hot-post-item">
                                            <div class="hot-post-content">
                                                <a href="javascript:;" class="post-tag"><?php echo e($row->category->name); ?></a>
                                                <h4 class="post-title"><a
                                                        href="<?php echo e(route('blog.details', $row->slug)); ?>"><?php echo e($row->title); ?></a>
                                                </h4>
                                                <div class="blog-post-meta">
                                                    <ul class="list-wrap">
                                                        <li><i
                                                                class="flaticon-calendar"></i><?php echo e($row->updated_at->toFormattedDateString()); ?>

                                                        </li>
                                                        <li><i
                                                                class="flaticon-history"></i><?php echo e($row->updated_at->diffForHumans()); ?>

                                                        </li>
                                                    </ul>
                                                </div>
                                            </div>
                                        </div>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </div>
                            </div>
                            <div class="sidebar-widget sidebar-widget-two">
                                <div class="sidebar-newsletter">
                                    <div class="icon"><i class="flaticon-envelope"></i></div>
                                    <h4 class="title">Daily Newsletter</h4>
                                    <p>Get all the top stories from Blogs to keep track.</p>
                                    <div class="sidebar-newsletter-form-two" id="subscribeform">
                                        <form method="post" id="subscribe_form">
                                            <?php echo csrf_field(); ?>
                                            <div class="form-grp">
                                                <input type="text" placeholder="Enter your e-mail" name="email">
                                                <button type="submit" class="btn" id="subscribe_form_btn">Subscribe Now</button>
                                            </div>
                                            <div class="form-check">
                                                <input type="checkbox" class="form-check-input" id="checkbox">
                                                <label for="checkbox">I agree to the terms & conditions</label>
                                            </div>
                                        </form>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>
<?php $__env->stopSection(); ?>
<?php $__env->startSection('custom-scripts'); ?>
    <script type="text/javascript" src="//cdnjs.cloudflare.com/ajax/libs/jquery/2.0.3/jquery.js"></script>
    <script defer type="text/javascript">
        (function() {
            var t = document.getElementsByTagName('script')[0];
            var s = document.createElement('script');
            s.async = true;
            s.src =
                'https://widget.nfusionsolutions.com/custom/monex/script/chart/1/a0fa8f6f-0b7b-4d1a-bb3f-045d29d8aee5/2572dba0-aff5-45e6-a242-01a24b36cbfa?symbols=';
            t.parentNode.insertBefore(s, t);
        })();
    </script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('user.layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/coupuzzt/realtimebrief.com/resources/views/user/pages/gold.blade.php ENDPATH**/ ?>