@extends('user.layouts.app')
@section('meta-content')

 @php
    $settings = \App\Models\GeneralSetting::find(1);
    @endphp
<title>@if($settings){{$settings->site_title}}@endif</title>
<meta name="description" content="@if($settings){{$settings->meta_description}}@endif">
<meta name="title" content="@if($settings){{$settings->meta_title}}@endif">
@endsection
@section('content')
<!-- breadcrumb-area -->
<div class="breadcrumb-area">
    <div class="container">
        <div class="row">
            <div class="col-lg-12">
                <div class="breadcrumb-content">
                    <nav aria-label="breadcrumb">
                        <ol class="breadcrumb">
                            <li class="breadcrumb-item"><a href="{{ route('index') }}">Home</a></li>
                            <li class="breadcrumb-item active" aria-current="page">{{ $page->slug }}</li>
                        </ol>
                    </nav>
                </div>
            </div>
        </div>
    </div>
</div>
<!-- breadcrumb-area-end -->

<!-- blog-details-area -->
<section class="blog-details-area pt-60 pb-60">
    <div class="container">
        <div class="author-inner-wrap">
            <div class="row justify-content-center">
                <div class="col-70">
                    <div class="blog-details-wrap">
                        <div class="blog-details-content mb-50">
                            <div class="blog-details-content-top">
                                <h2 class="title">{{ $page->title }}</h2>
                                
                            </div>
                            
                            {!! $page->details !!}
                        </div>
                        
                        
                    </div>
                </div>
                <div class="col-30">
                    <div class="sidebar-wrap">
                        <div class="sidebar-widget">
                            <div class="sidebar-search">
                                <form action="#">
                                    <input type="text" placeholder="Search . . .">
                                    <button type="submit"><i class="flaticon-search"></i></button>
                                </form>
                            </div>
                        </div>
                        
                        <div class="sidebar-widget sidebar-widget-two">
                            <div class="widget-title mb-30">
                                <h6 class="title">Recent News</h6>
                                <div class="section-title-line"></div>
                            </div>
                            <div class="hot-post-wrap">
                                @php
                                    $blog = $blogs->shift();
                                @endphp
                                <div class="hot-post-item">
                                    <div class="hot-post-thumb">
                                        <a href="{{ route('blog.details', $blog->slug) }}"><img
                                                src="{{ asset('admin-assets/images/blogs') }}/{{ $blog->feature_image }}"
                                                alt=""></a>
                                    </div>
                                    <div class="hot-post-content">
                                        <a href="javascript:;" class="post-tag">{{ $blog->category->name }}</a>
                                        <h4 class="post-title"><a
                                                href="{{ route('blog.details', $blog->slug) }}">{{ $blog->title }}</a>
                                        </h4>
                                        <div class="blog-post-meta">
                                            <ul class="list-wrap">
                                                <li><i
                                                        class="flaticon-calendar"></i>{{ $blog->updated_at->toFormattedDateString() }}
                                                </li>
                                                <li><i
                                                        class="flaticon-history"></i>{{ $blog->updated_at->diffForHumans() }}
                                                </li>
                                            </ul>
                                        </div>
                                    </div>
                                </div>
                                @foreach ($blogs as $row)
                                    <div class="hot-post-item">
                                        <div class="hot-post-content">
                                            <a href="javascript:;" class="post-tag">{{ $row->category->name }}</a>
                                            <h4 class="post-title"><a
                                                    href="{{ route('blog.details', $row->slug) }}">{{ $row->title }}</a>
                                            </h4>
                                            <div class="blog-post-meta">
                                                <ul class="list-wrap">
                                                    <li><i
                                                            class="flaticon-calendar"></i>{{ $row->updated_at->toFormattedDateString() }}
                                                    </li>
                                                    <li><i
                                                            class="flaticon-history"></i>{{ $row->updated_at->diffForHumans() }}
                                                    </li>
                                                </ul>
                                            </div>
                                        </div>
                                    </div>
                                @endforeach
                            </div>
                        </div>
                        <div class="sidebar-widget sidebar-widget-two">
                            <div class="sidebar-newsletter">
                                <div class="icon"><i class="flaticon-envelope"></i></div>
                                <h4 class="title">Daily Newsletter</h4>
                                <p>Get all the top stories from Blogs to keep track.</p>
                                <div class="sidebar-newsletter-form-two" id="subscribeform">
                                    <form method="post" id="subscribe_form">
                                            @csrf
                                            <div class="form-grp">
                                                <input type="text" placeholder="Enter your e-mail" name="email">
                                                <button type="submit" class="btn" id="subscribe_form_btn">Subscribe Now</button>
                                            </div>
                                            <div class="form-check">
                                                <input type="checkbox" class="form-check-input" id="checkbox">
                                                <label for="checkbox">I agree to the terms & conditions</label>
                                            </div>
                                        </form>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</section>
<!-- blog-details-area-end -->

@endsection