<footer id="uc-footer" class="uc-footer panel uc-dark">
    <div class="footer-outer py-4 lg:py-6 bg-white dark:bg-gray-900 text-gray-900 dark:text-white text-opacity-50">
        <div class="container max-w-xl">
            <div class="footer-inner vstack gap-6 xl:gap-8">
                <div class="uc-footer-bottom panel vstack gap-4 justify-center lg:fs-5">
                    <center>
                        <img class="w-200px text-dark dark:text-white" src="{{ asset('admin-assets/images/logos') }}/{{ $settings->footer_logo }}" alt="News5">
                    </center>
                    <nav class="footer-nav">
                        <ul class="nav-x gap-2 lg:gap-4 justify-center text-center text-uppercase fw-medium">
                            @php
                            $categories = \App\Models\Category::select('id', 'slug', 'name')->limit(5)->get();
                            
                        @endphp
                        @foreach ($categories as $key => $row)
                            <li><a class="hover:text-gray-900 dark:hover:text-white duration-150" href="{{ route('blogs.category', $row->slug) }}">{{ $row->name }}</a></li>
                        @endforeach
                        </ul>
                    </nav>
                    <div class="footer-social hstack justify-center gap-2 lg:gap-3">
                        <ul class="nav-x gap-2">
                            @php
                                $social_links = \App\Models\SocialMedia::get();
                            @endphp
                            @foreach($social_links as $link)
                            <li>
                                <a class="hover:text-gray-900 dark:hover:text-white duration-150" href="{{$link->url}}"><i class="icon icon-2 unicon-logo-{{$link->title}}"></i></a>
                            </li>
                            @endforeach
                           
                        </ul>
                        <div class="vr"></div>
                        
                    </div>
                    <div class="footer-copyright vstack sm:hstack justify-center items-center gap-1 lg:gap-2">
                        <p> Copyright ©
                            <script>
                                document.write(new Date().getFullYear())
                            </script>

                            @if ($settings)
                                {{ $settings->site_title }}
                            @endif All rights reserved.</p>
                        <ul class="nav-x gap-2 fw-medium">
                            @php
                            $pages = \App\Models\Page::all();
                        @endphp
                        @foreach ($pages as $page)
                            <li><a class="uc-link text-underline hover:text-gray-900 dark:hover:text-white duration-150" href="{{ route('page', $page->slug) }}">{{ $page->title }}</a>
                            </li>
                        @endforeach
                            
                        </ul>
                    </div>
                </div>
            </div>
        </div>
    </div>
</footer>

