@extends('admin.layouts.app')
@section('custom-styles')
    <!-- Bootstrap Select Css -->
    <link href="{{ asset('admin-assets/css/bootstrap-select.css') }}" rel="stylesheet" />
@endsection
@section('content')
    <div class="row clearfix">
        <div class="col-lg-12 col-md-12 col-sm-12">
            <div class="card">
                <div class="header">
                    <h2><strong>Edit </strong> User</h2>
                    
                </div>
                <div class="mt-2">
                    @include('admin.layouts.partials.messages')
                </div>
                <div class="body">
                    @if (count($errors) > 0)
                        <div class="alert alert-danger">
                            <strong>Whoops!</strong> There were some problems with your input.<br><br>
                            <ul>
                                @foreach ($errors->all() as $error)
                                    <li>{{ $error }}</li>
                                @endforeach
                            </ul>
                        </div>
                    @endif
                    <form method="POST" action="{{ route('users.update', $user->id) }}">
                        @method('patch')
                        @csrf
                        <label for="name">Name</label>
                        <div class="form-group">
                            <input type="text" id="name" class="form-control" name="name" placeholder="Enter User Name"
                                value="{{ $user->name }}" required>
                            @if ($errors->has('name'))
                                <span class="text-danger text-left">{{ $errors->first('name') }}</span>
                            @endif
                        </div>
                        <label for="email">Email</label>
                        <div class="form-group">
                            <input type="email" id="email" class="form-control" name="email" placeholder="Enter User Email"
                                value="{{ $user->email }}" required>
                            @if ($errors->has('email'))
                                <span class="text-danger text-left">{{ $errors->first('email') }}</span>
                            @endif
                        </div>
                        
                        <label for="status">Status</label>

                        <div class="form-group">
                            <select  class="form-control show-tick" name="status">
                                <option value="{{ $user->status }}">{{ $user->status }}</option>
                                <option value="">--Select Status--</option>
                                <option value="Active">Active</option>
                                <option value="DeActive">DeActive</option>
                            </select>
                        </div>


                        <button type="submit" class="btn btn-raised btn-primary  waves-effect">Save
                            Changes</button>
                        <a href="{{ route('users.index') }}" class="btn btn-default">Back</a>
                    </form>
                </div>
            </div>
        </div>
    </div>
@endsection
@section('custom-scripts')
@endsection
