@extends('admin.layouts.app')

@section('content')
    <div class="row clearfix">
        <div class="col-lg-12">
            <div class="card">
                <div class="header">
                    <h2><strong>All</strong> Stores </h2>
                    <ul class="header-dropdown">
                        <li class="dropdown">
                            <a href="{{ route('stores.create') }}" class="btn btn-primary btn-sm float-right">Add
                                Store</a>
                        </li>
                    </ul>
                </div>
                <div class="mt-2">
                    @include('admin.layouts.partials.messages')
                </div>
                <div class="body">
                    <div class="table-responsive">
                        <table class="table table-bordered table-striped table-hover js-basic-example dataTable">
                            <thead>
                                <tr>
                                    <th>Image</th>
                                    <th>Name</th>
                                    <th>Category</th>
                                    <th>Event</th>
                                    <th>Url</th>
                                    <th>Actions</th>
                                </tr>
                            </thead>
                            <tfoot>
                                <tr>
                                    <th>Image</th>
                                    <th>Name</th>
                                    <th>Category</th>
                                    <th>Event</th>
                                    <th>Url</th>
                                    <th>Actions</th>
                                </tr>
                            </tfoot>
                            <tbody>
                                @foreach ($stores as $key => $store)
                                    <tr>
                                        <td><img src="{{ asset('admin-assets/images/stores') }}/{{ $store->feature_image }}"
                                                alt="" width="40"></td>
                                        <td><a href="{{ route('store_coupon',$store->id) }}">{{ $store->name }}</a></td>
                                        <td>{{ $store->category->name }}</td>
                                        <td>{{ $store->event->name }}</td>
                                        <td><a href="{{$store->url}}"><i class="zmdi zmdi-link"></i></a></td>
                                        <td>
                                            <a class="btn btn-primary btn-sm"
                                                href="{{ route('stores.edit', $store->id) }}">Edit</a>

                                            {!! Form::open(['method' => 'DELETE', 'route' => ['stores.destroy', $store->id], 'style' => 'display:inline']) !!}
                                            {!! Form::submit('Delete', ['class' => 'btn btn-danger btn-sm']) !!}
                                            {!! Form::close() !!}
                                        </td>
                                    </tr>
                                @endforeach
                            </tbody>
                        </table>
                        <div class="d-flex">
                            {!! $stores->links('pagination::bootstrap-4') !!}
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
@endsection

@section('custom-scripts')
   
@endsection
