@extends('admin.layouts.app')
@section('custom-styles')
    <!-- JQuery DataTable Css -->
    <link rel="stylesheet" href="{{ asset('admin-assets/css/dataTables.bootstrap4.min.css') }}">
@endsection
@section('content')
    <div class="row clearfix">
        <div class="col-lg-12">
            <div class="card">
                <div class="header">
                    <h2><strong>All</strong> Permissions </h2>
                    <ul class="header-dropdown">
                        <li class="dropdown">
                            <a href="{{ route('permissions.create') }}" class="btn btn-primary btn-sm float-right">Add
                                permissions</a>
                        </li>
                    </ul>
                </div>
                <div class="mt-2">
                    @include('admin.layouts.partials.messages')
                </div>
                <div class="body">
                    <div class="body">
                        <div class="table-responsive">
                            <table class="table table-bordered table-striped table-hover js-basic-example dataTable">
                                <thead>
                                    <tr>
                                        <th>Name</th>
                                        <th>Guard</th>
                                        <th>Actions</th>
                                    </tr>
                                </thead>
                                <tfoot>
                                    <tr>
                                        <th>Name</th>
                                        <th>Guard</th>
                                        <th>Actions</th>
                                    </tr>
                                </tfoot>
                                <tbody>
                                    @foreach ($permissions as $permission)
                                        <tr>
                                            <td>{{ $permission->name }}</td>
                                            <td>{{ $permission->guard_name }}</td>
                                            <td><a href="{{ route('permissions.edit', $permission->id) }}"
                                                    class="btn btn-info btn-sm">Edit</a>
                                                {!! Form::open([
                                                    'method' => 'DELETE',
                                                    'route' => ['permissions.destroy', $permission->id],
                                                    'style' => 'display:inline',
                                                ]) !!}
                                                {!! Form::submit('Delete', ['class' => 'btn btn-danger btn-sm']) !!}
                                                {!! Form::close() !!}
                                            </td>
                                        </tr>
                                    @endforeach
                                </tbody>
                            </table>
                            <div class="d-flex">
                                {!! $roles->links() !!}
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
@endsection
@section('custom-scripts')
    <!-- JQuery DataTable Js -->
    <script src="{{ asset('admin-assets/js/datatablescripts.bundle.js') }}"></script>
    <script src="{{ asset('admin-assets/js/jquery-datatable.js') }}"></script>
@endsection
