<!doctype html>
<html class="no-js " lang="en">

<head>
    @php
        $settings = \App\Models\GeneralSetting::find(1);
    @endphp

    <meta charset="utf-8">
    <meta http-equiv="x-admin-ua-compatible" content="ie=edge">
    <title>
        @if ($settings)
            {{ $settings->site_title }}
        @endif
    </title>
    @yield('meta-content')
    <link rel="shortcut icon" type="image/x-admin-icon"
        href="@if ($settings) {{ asset('admin-assets/images/logo') }}/{{ $settings->favicon }} @endif">
    <x-admin-styles-component></x-admin-styles-component>
</head>

<body class="theme-black">
    <div class="authentication">
        <div class="container">
            <div class="col-md-12 content-center">
                <div class="row">
                    <div class="col-lg-6 col-md-12">
                        <div class="company_detail">
                            <h4 class="logo"><img
                                    src="@if ($settings) {{ asset('admin-assets/images/logo') }}/{{ $settings->favicon }} @endif"
                                    alt="">
                                @if ($settings)
                                    {{ $settings->site_title }}
                                @endif
                            </h4>
                            <h3> <strong>Admin Dashboard</strong></h3>
                            <p>
                                @if ($settings)
                                    {{ $settings->about }}
                                @endif
                            </p>
                            <div class="footer">
                                <ul class="social_link list-unstyled">
                                    @php
                                        $socials = \App\Models\SocialMedia::all();
                                    @endphp
                                    @foreach ($socials as $row)
                                        <li> <a href="{{ $row->url }}" target="_blank">
                                            <i class="{{ $row->icon }} me-2"></i></a></li>
                                    @endforeach
                                </ul>
                                <hr>
                                <ul>
                                    @php
                                    $pages = \App\Models\Page::all();
                                @endphp
                                @foreach ($pages as $page)
                                    <li><a class href="">{{ $page->title }}</a>
                                    </li>
                                @endforeach
                                </ul>
                            </div>
                        </div>
                    </div>
                    <div class="col-lg-5 col-md-12 offset-lg-1">
                        <div class="mt-2">
                            @include('admin.layouts.partials.messages')
                        </div>
                        <div class="card-plain">
                            <div class="header">
                                <h5>Log in</h5>
                            </div>
                            <form class="form" action="{{ route('admin.login.validate') }}" method="post">
                                @csrf
                                <div class="input-group">
                                    <input type="email" class="form-control" placeholder="User Name" name="email">
                                    <div class="input-group-append">
                                        <span class="input-group-text"><i class="zmdi zmdi-account-circle"></i></span>
                                    </div>
                                </div>
                                <div class="input-group">
                                    <input type="password" class="form-control" placeholder="Password" name="password">
                                    <div class="input-group-append">
                                        <span class="input-group-text"><i class="zmdi zmdi-lock"></i></span>
                                    </div>
                                </div>

                                <div class="footer">
                                    <button type="submit" class="btn btn-primary btn-round btn-block">SIGN IN</button>
                                   
                                </div>
                            </form>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <x-admin-scripts-component></x-admin-scripts-component>
</body>

</html>
